/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.security;

import java.util.HashMap;
import java.util.Map;

public class AccessContext {
    private String uuid;
    private String realIP;
    private String intent;
    private String identifier;
    private String captcha;
    private Map<String, Object> attributes;

    protected Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    public Object getAttribute(String name) {
        if (this.attributes != null && this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        this.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    AccessContext(String uuid, String realIP, String intent, String identifier, String captcha, Map<String, Object> attributes) {
        this.uuid = uuid;
        this.realIP = realIP;
        this.intent = intent;
        this.identifier = identifier;
        this.captcha = captcha;
        this.attributes = attributes;
    }

    public static AccessContextBuilder builder() {
        return new AccessContextBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getRealIP() {
        return this.realIP;
    }

    public String getIntent() {
        return this.intent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getCaptcha() {
        return this.captcha;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setRealIP(String realIP) {
        this.realIP = realIP;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public static class AccessContextBuilder {
        private String uuid;
        private String realIP;
        private String intent;
        private String identifier;
        private String captcha;
        private Map<String, Object> attributes;

        AccessContextBuilder() {
        }

        public AccessContextBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public AccessContextBuilder realIP(String realIP) {
            this.realIP = realIP;
            return this;
        }

        public AccessContextBuilder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public AccessContextBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public AccessContextBuilder captcha(String captcha) {
            this.captcha = captcha;
            return this;
        }

        public AccessContextBuilder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public AccessContext build() {
            return new AccessContext(this.uuid, this.realIP, this.intent, this.identifier, this.captcha, this.attributes);
        }

        public String toString() {
            return "AccessContext.AccessContextBuilder(uuid=" + this.uuid + ", realIP=" + this.realIP + ", intent=" + this.intent + ", identifier=" + this.identifier + ", captcha=" + this.captcha + ", attributes=" + this.attributes + ")";
        }
    }
}

