/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt;

import com.xunyi.micro.propagation.PropagationAutoConfiguration;
import com.xunyi.micro.propagation.context.CurrentContext;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.ShuntProperties;
import com.xunyi.micro.shunt.propagation.CurrentShuntContext;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"micro.shunt.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={CurrentContext.class})
@AutoConfigureAfter(value={PropagationAutoConfiguration.class})
@EnableConfigurationProperties(value={ShuntProperties.class})
public class ShuntAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CurrentShuntContext currentShuntContext(CurrentContext currentContext) {
        return new CurrentShuntContext(currentContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public Shunt shunt(CurrentShuntContext currentShuntContext) {
        Shunt.ShuntBuilder builder = Shunt.builder().currentShuntContext(currentShuntContext);
        return builder.build();
    }
}

