/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.propagation.instrument.web.servlet;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Context;
import com.xunyi.micro.propagation.context.CurrentContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ServletPropagationFilter
implements Filter {
    private Context.Extractor<HttpServletRequest> extractor;
    private CurrentContext currentContext;

    public ServletPropagationFilter(Propagation propagation, CurrentContext currentContext) {
        this.extractor = propagation.extractor(new Propagation.Getter<HttpServletRequest>(){

            @Override
            public String get(HttpServletRequest carrier, String key) {
                return carrier.getHeader(key);
            }
        });
        this.currentContext = currentContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Context context = this.extractor.extract(httpRequest);
        try (CurrentContext.Scope scope = this.currentContext.newScope(context);){
            chain.doFilter(request, response);
        }
    }
}

