/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.message.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.xunyi.micro.message.ErrorInfo;
import com.xunyi.micro.message.XYError;
import java.io.IOException;
import java.util.Locale;
import org.springframework.context.MessageSource;

public class MessageModule
extends SimpleModule {
    private MessageSource messageSource;

    public MessageModule(MessageSource messageSource) {
        super(Version.unknownVersion());
        this.messageSource = messageSource;
        this.addSerializer(XYError.class, (JsonSerializer)new ErrorSerializer());
    }

    public class ErrorSerializer
    extends StdScalarSerializer<XYError> {
        private ErrorSerializer() {
            super(XYError.class);
        }

        private String convertMessageCode(String type) {
            return type.toLowerCase().replace("_", ".");
        }

        public void serialize(XYError error, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String errorCode = error.getCode();
            Object[] args = error.getArgs();
            String messageCode = this.convertMessageCode(errorCode);
            String message = null;
            try {
                message = MessageModule.this.messageSource.getMessage(messageCode, args, Locale.CHINA);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (message == null) {
                message = errorCode;
            }
            gen.writeObject((Object)new ErrorInfo(errorCode, message));
        }
    }
}

