/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.data.transformer;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class BeanCopyFunction<I, O>
implements Function<I, O> {
    protected final Class<O> entityClass;

    public BeanCopyFunction() {
        this(null);
    }

    public BeanCopyFunction(Class<O> clazz) {
        if (clazz == null) {
            Class<?> copyFunction = this.getClass();
            List arguments = ClassTypeInformation.from(copyFunction).getRequiredSuperTypeInformation(BeanCopyFunction.class).getTypeArguments();
            clazz = BeanCopyFunction.resolveTypeParameter(arguments, 1, () -> String.format("Could not resolve Output type of %s!", copyFunction));
        }
        this.entityClass = clazz;
    }

    private static Class<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index, Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index).getType();
    }

    @NonNull
    private O newOutputInstance() {
        return (O)BeanUtils.instantiateClass(this.entityClass);
    }

    @Override
    public O apply(I input) {
        O output = this.newOutputInstance();
        Assert.notNull(output, (String)"BeanCopyFunction O Annotation require not null");
        BeanUtils.copyProperties(input, output);
        return output;
    }
}

