package com.xunyi.rocket;

import com.google.common.collect.Maps;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.springframework.beans.factory.BeanFactory;

import java.util.Map;

public class RocketMQProducerRegistry {

    private Map<String, RocketMQProducerConfig> producerConfigMap = Maps.newHashMap();
    
    public MQProducer get(String value) {

        RocketMQProducerConfig producerConfig = producerConfigMap.get(value);
        if (producerConfig == null) {
            throw new IllegalArgumentException("name:" + value + " not exist");
        }
        DefaultMQProducer producer = new DefaultMQProducer(value);
        producer.setNamesrvAddr(producerConfig.getNamesrvAddr());



        return producer;
    }
}
