package com.xunyi.rocket;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotationMetadata;



public class RocketMQProducerRegistrar implements ImportBeanDefinitionRegistrar, BeanFactoryAware, EnvironmentAware, ApplicationContextAware {



    private Environment environment;

    private BeanFactory beanFactory;

    private ApplicationContext applicationContext;

//    @Autowired
//    public RocketMQProducerRegistrar(ConfigurationPropertiesBindingPostProcessor bindingPostProcessor) {
//        this.bindingPostProcessor = bindingPostProcessor;
//    }

    //    @Autowired
//    public RocketMQProducerRegistrar(RocketMQProperties properties) {
//        this.properties = properties;
//    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
//        environment.
        ConfigurationPropertiesBindingPostProcessor processor = beanFactory.getBean(ConfigurationPropertiesBindingPostProcessor.class);
//        RocketMQProperties properties = new RocketMQProperties();
//        processor.postProcessBeforeInitialization(properties, "RocketMQProperties");
        StandardEnvironment env = null;
        String property = environment.getProperty("micro.rocketmq.test");
        System.out.println(property);
//        if (properties == null) {
//            return;
//        }

//        Map<String, RocketMQProducerConfig> producers = properties.getProducer();
//        for (String group : producers.keySet()) {
//            RocketMQProducerConfig config = producers.get(group);
//            this.registerRocketMQProducer(registry, group, config);
//        }
    }


    private void registerRocketMQProducer(BeanDefinitionRegistry registry, String group, RocketMQProducerConfig config) {

        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(RocketMQProducerFactoryBean.class);
        definition.addPropertyValue("group", group);
        definition.addPropertyValue("config", config);
        String name = group + "RocketMQProducer";
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        definition.setAutowireMode(AbstractBeanDefinition.AUTOWIRE_BY_TYPE);
        BeanDefinitionHolder holder = new BeanDefinitionHolder(beanDefinition, name);
        BeanDefinitionReaderUtils.registerBeanDefinition(holder, registry);
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
