package com.xunyi.rocket;

import lombok.Getter;
import lombok.Setter;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;


public class RocketMQProducerFactoryBean implements FactoryBean<MQProducer>, InitializingBean, DisposableBean {

    @Getter @Setter
    private String group;
    @Getter @Setter
    private RocketMQProducerConfig config;

    private MQProducer instance;


    @Override
    public void afterPropertiesSet() throws Exception {
        DefaultMQProducer instance = new DefaultMQProducer(this.group);
        instance.setNamesrvAddr(this.config.getNamesrvAddr());
        instance.start();
        this.instance = instance;

    }
    @Override
    public void destroy() throws Exception {
        this.instance.shutdown();
    }

    @Override
    public MQProducer getObject() throws Exception {
        return this.instance;
    }

    @Override
    public Class<?> getObjectType() {
        return MQProducer.class;
    }


}
