package com.xunyi.micro.web.view;

import org.springframework.web.servlet.View;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class TextView implements View {

    public static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=UTF-8";

    private String value;

    public TextView(String value) {
        this.value = value;
    }

    @Override
    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    @Override
    public void render(Map<String, ?> model, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        try (OutputStream outputStream = response.getOutputStream()) {
            outputStream.write(value.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
    }
}
