package com.xunyi.micro.validate.constraintvalidators;

import com.google.common.base.Strings;
import com.xunyi.micro.validate.constraints.NoTaboo;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class NoTabooValidator implements ConstraintValidator<NoTaboo, String> {
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String tabooWord = TabooUtils.findWord(value);
        return Strings.isNullOrEmpty(tabooWord);
    }
}
