package com.xunyi.micro.shunt;

import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.ServerListUpdater;
import com.xunyi.micro.profile.Alpha;
import com.xunyi.micro.profile.Beta;
import com.xunyi.micro.profile.Prod;
import com.xunyi.micro.shunt.loadbalancer.group.ShuntingContextRule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class ShuntRibbonClientConfiguration {

    @RibbonClientName
    private String name = "client";

    public ShuntRibbonClientConfiguration() {
    }

    /**
     * 开发&测试 环境
     */
    @Beta
    @Alpha
    @Bean
    public ServerListUpdater testRibbonServerListUpdater() {
        return new PollingServerListUpdater(1000,1000);
    }

    @Prod
    @Bean
    public ServerListUpdater ribbonServerListUpdater() {
        return new PollingServerListUpdater(1000,3000);
    }

    @Bean
    @ConditionalOnMissingBean
    public ShuntingContextRule shuntingRule() {
        return new ShuntingContextRule();
    }

}
