package com.xunyi.micro.security.configuration;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import org.apache.logging.log4j.util.Strings;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Iterator;
import java.util.List;

public class StringListAdapter extends XmlAdapter<String, List<String>> {

    private static final String SPLIT_CHAR = ",";
    @Override
    public List<String> unmarshal(String v) throws Exception {
        Iterator<String> iterator = Splitter.on(SPLIT_CHAR).split(v).iterator();
        List<String> values = Lists.newArrayList();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (Strings.isNotBlank(value)) {
                values.add(value);
            }
        }
        return values;
    }

    @Override
    public String marshal(List<String> v) throws Exception {
        throw new UnsupportedOperationException();
    }
}
