package com.xunyi.micro.security.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xunyi.micro.security.PryService;
import com.xunyi.micro.security.policy.PryMapper;
import com.xunyi.micro.security.policy.PryPolicy;
import org.springframework.beans.*;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;


import java.lang.reflect.Field;

import java.util.List;
import java.util.Map;

/**
 * 自动扫描pry文件
 */
public class PryPolicyConfigService extends ApplicationObjectSupport implements InitializingBean, ApplicationListener<RefreshScopeRefreshedEvent> {


//    //配置文件路径
//    private URL url;
    private TypeConverter typeConverter = new SimpleTypeConverter();

    @Autowired
    private PryService pryService;

    private PryPolicyDataSource source;


    private PryPolicyConfigRunnable runnable = new PryPolicyConfigRunnable();

    public PryPolicyConfigService(PryPolicyDataSource source) {
        this.source = source;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void start() {
        runnable.run();
    }

    @Override
    public void onApplicationEvent(@NonNull RefreshScopeRefreshedEvent refreshScopeRefreshedEvent) {
        //刷新配置
        runnable.run();
    }

    public class PryPolicyConfigRunnable implements Runnable {
        @Override
        public void run() {
            try{
                PryProperties properties = source.readProperties();
                List<PryMapper> mappers = Lists.newArrayList();
                Map<String, PryPolicy> policyMap = Maps.newHashMap();
                for (PryProperties.PryMapper mapperProperty : properties.getMapper()) {
                    PryMapper mapper = new PryMapper();
                    BeanUtils.copyProperties(mapperProperty, mapper);
                    mappers.add(mapper);
                }
                for (PryProperties.PryPolicy policyProperty : properties.getPolicy()) {
                    String className = policyProperty.getClazz();
                    PryPolicy policy = this.loadPolicy(className, policyProperty.getInitParams());
                    policyMap.put(policyProperty.getName(), policy);
                }
                pryService.configuration(mappers, policyMap);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        private PryPolicy loadPolicy(String className, Map<String, String> initParams) throws Exception {
            Class<? extends PryPolicy> clazz = (Class<? extends PryPolicy>) Class.forName(className);

            AutowireCapableBeanFactory beanFactory = getApplicationContext().getAutowireCapableBeanFactory();

            PryPolicy target = beanFactory.createBean(clazz);
            for (Field field : clazz.getDeclaredFields()) {
                String fieldName = field.getName();
                if (initParams.containsKey(fieldName)) {
                    Class<?> fieldType = field.getType();
                    String valueString = initParams.get(fieldName);
                    Object value = typeConverter.convertIfNecessary(valueString, fieldType);
                    ReflectionUtils.makeAccessible(field);
                    ReflectionUtils.setField(field, target, value);
                }
            }
            return target;
        }
    }

}
