package com.xunyi.micro.security;


import com.xunyi.micro.security.policy.PryPolicy;

public class PryContext {

    private AccessContext context;

    private PryPolicy policy;

    public PryContext(AccessContext context, PryPolicy policy) {
        this.context = context;
        this.policy = policy;
    }


    public boolean tryAccess() {
        try {
            policy.access(context);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public void access() {
        policy.access(context);
    }


    public void mark() {
        policy.mark(context);
    }
}
