package com.xunyi.micro.security;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 访问上下文
 *
 */
@Getter @Setter @Builder
public class AccessContext {

    //访问者ID
    private String uuid;

    //IP
    private String realIP;

    //意图
    private String intent;

    //访问标识 (如 用户名 手机号等)
    private String identifier;


    //验证码
    private String captcha;

    private Map<String, Object> attributes;

    protected Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<>();
        }
        return attributes;
    }

    public Object getAttribute(String name) {
        if (attributes != null && attributes.containsKey(name)) {
            return attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        this.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        if (attributes != null) {
            attributes.remove(name);
        }
    }
}
