package com.xunyi.micro.propagation.instrument.web.client.feign;

import feign.Client;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.util.ClassUtils;

public class PropagationFeignObjectWrapper {
    private static final boolean ribbonPresent;

    static {
        ribbonPresent = ClassUtils.isPresent(
                "org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient",
                null)
                && ClassUtils.isPresent(
                "org.springframework.cloud.netflix.ribbon.SpringClientFactory",
                null);
    }

    private final BeanFactory beanFactory;

    public PropagationFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }


    Object wrap(Object bean){
        if (bean instanceof Client && !(bean instanceof PropagationFeignClient)) {

            if (ribbonPresent && bean instanceof PropagationLoadBalancerFeignClient) {
                return bean;
            }

            if (ribbonPresent && bean instanceof LoadBalancerFeignClient) {
                LoadBalancerFeignClient client = (LoadBalancerFeignClient) bean;
                return new PropagationLoadBalancerFeignClient(
                        (Client) wrap(client.getDelegate()), factory(), clientFactory(), this.beanFactory
                );
            }
            return new LazyPropagationFeignClient(this.beanFactory, (Client) bean);
        }
        return bean;
    }

    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;

    private SpringClientFactory springClientFactory;

    private CachingSpringLoadBalancerFactory factory() {
        if (this.cachingSpringLoadBalancerFactory == null) {
            this.cachingSpringLoadBalancerFactory = this.beanFactory
                    .getBean(CachingSpringLoadBalancerFactory.class);
        }
        return this.cachingSpringLoadBalancerFactory;
    }
    private SpringClientFactory clientFactory() {
        if (this.springClientFactory == null) {
            this.springClientFactory = this.beanFactory
                    .getBean(SpringClientFactory.class);
        }
        return this.springClientFactory;
    }

}
