package com.xunyi.micro.propagation.instrument.web.client;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Context;
import com.xunyi.micro.propagation.context.CurrentContext;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

public class ResponseHttpHeadersFilter implements HttpHeadersFilter  {

    private static final Propagation.Getter<HttpHeaders> GETTER = new Propagation.Getter<HttpHeaders>() {
        @Override
        public String get(HttpHeaders carrier, String key) {
            return carrier.getFirst(key);
        }
    };

    private Context.Extractor<HttpHeaders> extractor;
    private CurrentContext currentContext;

    public ResponseHttpHeadersFilter(Propagation propagation, CurrentContext currentContext)  {
        this.extractor = propagation.extractor(GETTER);
        this.currentContext = currentContext;
    }

    @Override
    public boolean supports(Type type) {
        return type.equals(Type.RESPONSE);
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
//        exchange.getAttribute()
        return input;
    }
}
