package com.xunyi.micro.propagation.instrument.web.client;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Context;
import com.xunyi.micro.propagation.context.CurrentContext;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;


public class RequestHttpHeadersFilter implements HttpHeadersFilter {

    private static final Propagation.Setter<HttpHeaders> SETTER = new Propagation.Setter<HttpHeaders>() {
        @Override
        public void put(HttpHeaders carrier, String key, String value) {
            carrier.set(key, value);
        }
    };

    private Context.Injector<HttpHeaders> injector;
    private CurrentContext currentContext;

    public RequestHttpHeadersFilter(Propagation propagation, CurrentContext currentContext) {
        this.injector = propagation.injector(SETTER);
        this.currentContext = currentContext;
    }

    @Override
    public boolean supports(Type type) {
        return type.equals(Type.REQUEST);
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        headers.addAll(input);
        injector.inject(currentContext.get(), headers);
        return headers;
    }
}
