package com.xunyi.micro.propagation.instrument.web;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.PropagationAutoConfiguration;
import com.xunyi.micro.propagation.context.CurrentContext;
import com.xunyi.micro.propagation.instrument.web.servlet.ServletPropagationFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import javax.servlet.DispatcherType;

@Configuration
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(PropagationAutoConfiguration.class)
public class WebServletPropagationAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public ServletPropagationFilter servletPropagationFilter(Propagation propagation, CurrentContext currentContext) {
        return new ServletPropagationFilter(propagation, currentContext);
    }

    @Bean
    public FilterRegistrationBean shuntServletFilter(ServletPropagationFilter servletPropagationFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean<>(servletPropagationFilter);
        filterRegistrationBean.setDispatcherTypes(
                DispatcherType.ASYNC,
                DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE,
                DispatcherType.REQUEST
        );
        filterRegistrationBean.setOrder(
                Ordered.HIGHEST_PRECEDENCE + 5
        );
        return filterRegistrationBean;
    }

}
