package com.xunyi.micro.propagation.instrument.web;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.CurrentContext;
import com.xunyi.micro.propagation.instrument.web.client.RequestHttpHeadersFilter;
import com.xunyi.micro.propagation.instrument.web.client.ResponseHttpHeadersFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class WebClientPropagationAutoConfiguration {


    /**
     * Spring Cloud Gateway
     */
    @Configuration(proxyBeanMethods = false)
    @ConditionalOnClass(HttpHeadersFilter.class)
    static class HttpHeadersFilterConfig {

        /**
         * 对请求传播处理
         */
        @Bean
        public HttpHeadersFilter requestHttpHeadersFilter(Propagation propagation, CurrentContext currentContext) {
            return new RequestHttpHeadersFilter(propagation, currentContext);
        }

        /**
         * 对响应传播处理
         */
        @Bean
        public HttpHeadersFilter responseHttpHeadersFilter(Propagation propagation, CurrentContext currentContext){
            return new ResponseHttpHeadersFilter(propagation, currentContext);
        }

    }
}
