package com.xunyi.micro.propagation.instrument.reactor;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration(proxyBeanMethods = false)
@ConditionalOnClass(Mono.class)
//@AutoConfigureAfter(WebFluxPropagationAutoConfiguration.class)
public class ReactorPropagationAutoConfiguration {


    @Configuration(proxyBeanMethods = false)
    static class ReactorPropagationConfiguration {

        @Bean
        @ConditionalOnMissingBean
        static HookRegisteringBeanDefinitionRegistryPostProcessor propagationHookRegisteringBeanDefinitionRegistryPostProcessor() {
            return new HookRegisteringBeanDefinitionRegistryPostProcessor();
        }

    }



}
