package com.xunyi.micro.propagation.instrument.reactor;

import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;

public interface PassingSubscription<T> extends Subscription, CoreSubscriber<T>, Fuseable.QueueSubscription<T>{
    @Override
    default T poll() {
        return null;
    }

    @Override
    default int requestFusion(int i) {
        return Fuseable.NONE; // always negotiate to no fusion
    }

    @Override
    default int size() {
        return 0;
    }

    @Override
    default boolean isEmpty() {
        return true;
    }

    @Override
    default void clear() {
        // NO-OP
    }
}
