package com.xunyi.micro.message;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.Nullable;

import java.io.Serializable;

/**
 * 表示可序列化 以供message convert -> json
 * @param <T>
 */
@ToString
@Getter @Setter
public class Return<T> implements Serializable {

    private @Nullable IError error;

    private @Nullable T data;

    private Return() {

    }

    protected Return(@Nullable IError error, @Nullable  T data) {
        this.error = error;
        this.data = data;
    }


}
