package com.xunyi.micro.grpc.discovery;

import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.GrpcUtil;
import org.springframework.cloud.client.discovery.DiscoveryClient;

import java.net.URI;

public class DiscoveryNameResolverProvider extends NameResolverProvider {

    private final DiscoveryClient client;

    public DiscoveryNameResolverProvider(DiscoveryClient client) {
        this.client = client;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 5;
    }

    @Override
    public NameResolver newNameResolver(URI uri, Attributes attributes) {
        return new DiscoveryNameResolver(uri.toString(), client, attributes,  GrpcUtil.TIMER_SERVICE);
    }

    @Override
    public String getDefaultScheme() {
        return "discovery";
    }
}
