package com.xunyi.micro.feature.lunar.jackson;


import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.xunyi.micro.feature.lunar.LunarDate;
import com.xunyi.micro.feature.lunar.LunarUtils;

import java.io.IOException;

/**
 *  \@JsonSerialize(using = LunarDateJsonSerializer.class)
 *  LunarDate lunarBirthDate;
 */
public class LunarDateJsonSerializer extends JsonSerializer<LunarDate> {
    @Override
    public void serialize(LunarDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value != null) {
            gen.writeString(LunarUtils.format(value));
        } else {
            gen.writeNull();
        }
    }
}
