package com.xunyi.micro.data.page;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.springframework.data.domain.Page;

import java.io.IOException;

public class PageSerializer extends StdScalarSerializer<Page> {

    public PageSerializer() {
        super(Page.class);
    }

    @Override
    public void serialize(Page page, JsonGenerator gen, SerializerProvider provider) throws IOException {
        PageInfo pageInfo = new PageInfo(page.getContent(), page.getTotalElements());
        gen.writeObject(pageInfo);
    }
}
