package com.xunyi.micro.data.mongo.util;

import com.google.common.base.Strings;
import org.bson.BsonRegularExpression;
import org.springframework.data.mongodb.core.query.Criteria;

import java.time.Instant;
import java.util.Map;

public class CriteriaUtils {

    public static BsonRegularExpression startWith(String value) {
        return new BsonRegularExpression("^" + value);
    }
    public static BsonRegularExpression endWith(String value) {
        return new BsonRegularExpression(value + "$");
    }
    public static BsonRegularExpression contains(String value) {
        return new BsonRegularExpression(".*" + value + ".*");
    }
    public static BsonRegularExpression containsIgnoreCase(String value) {
        return new BsonRegularExpression(".*" + value + ".*", "i");
    }

    public static void filter(Criteria criteria, Map<String, Object> options) {
        options.forEach((key, value) -> {
            boolean filter = false;
            if (value instanceof String) {
                filter = !Strings.isNullOrEmpty((String)value);
            } else {
                filter = value != null;
            }
            if (filter) {
                criteria.and(key).is(value);
            }
        });
    }
    public static void between(Criteria criteria, String key, Instant startAt, Instant endAt) {
        if (startAt != null || endAt != null) {
            Criteria keyCriteria = criteria.and(key);
            if (startAt != null) {
                keyCriteria.gt(startAt);
            }
            if (endAt != null) {
                keyCriteria.lt(endAt);
            }
        }
    }
}
