package com.xunyi.micro.access.predicate;

import com.xunyi.micro.access.AccessContext;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.AntPathMatcher;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import java.util.function.Predicate;

public class HostPredicateFactory extends AbstractPredicateFactory<HostPredicateFactory.Config>{

    private AntPathMatcher pathMatcher = new AntPathMatcher(".");

    @Override
    public Predicate<AccessContext> apply(Config config) {
        return new Predicate<AccessContext>() {
            @Override
            public boolean test(AccessContext context) {
                return pathMatcher.match(config.pattern, context.getHost());
            }
        };
    }

    @Getter
    @Setter
    @Validated
    public static class Config {

        @NotEmpty
        private String pattern;
    }
}
