package com.xunyi.money.jackson.ser;


import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.xunyi.money.SimpleMoney;

import java.io.IOException;
import java.lang.reflect.Type;

public class SimpleMoneySerializer extends StdScalarSerializer<SimpleMoney> {
    public SimpleMoneySerializer() {
        super(SimpleMoney.class);
    }

    @Override
    public void serialize(SimpleMoney money, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeNumber(money.getBigDecimal());
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return createSchemaNode("number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor,
                                        JavaType typeHint) throws JsonMappingException
    {
        visitFloatFormat(visitor, typeHint, JsonParser.NumberType.FLOAT);
    }

}
