package com.xunyi.micro.token;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;

/**
 * SNS Token 包装
 */
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = WechatSNSToken.class, name = "WECHAT"),
        @JsonSubTypes.Type(value = XunLeiSNSToken.class, name = "XUNLEI"),
        @JsonSubTypes.Type(value = AlipaySNSToken.class, name = "ALIPAY"),
})
@Getter @Setter
public abstract class SNSToken implements TokenNamed{

    private static final String NAME = "SNSToken";

    private SNSTokenType type;

    private Instant expireAt;

    protected SNSToken(SNSTokenType type) {
        this.type = type;
    }


    @Override
    public String name() {
        return NAME;
    }
}
