package com.xunyi.micro.slf4j.web.servlet;

import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import org.slf4j.MDC;

import javax.servlet.*;
import java.io.IOException;

public class Slf4jTracingFilter implements Filter {

    private static final String TRACE_ID_KEY = "X-TraceID";
    private HttpTracing tracing;

    public static Slf4jTracingFilter create(HttpTracing httpTracing) {
        return new Slf4jTracingFilter(httpTracing);
    }

    protected Slf4jTracingFilter(HttpTracing tracing) {
        this.tracing = tracing;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TraceContext context = tracing.tracing().currentTraceContext().get();
        String traceId = context.traceIdString();
        MDC.put(TRACE_ID_KEY, traceId);
        chain.doFilter(request, response);
        MDC.remove(TRACE_ID_KEY);
    }
}
