package com.xunyi.micro.slf4j.web;

import brave.http.HttpTracing;
import com.xunyi.micro.slf4j.web.servlet.Slf4jTracingFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import javax.servlet.DispatcherType;

@Configuration
@ConditionalOnBean(HttpTracing.class)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(TraceWebServletAutoConfiguration.class)
public class Slf4jTraceWebServletAutoConfiguration {

    @Bean
    public FilterRegistrationBean<Slf4jTracingFilter> slf4jTraceWebFilter(
            Slf4jTracingFilter tracingFilter
    ) {
        FilterRegistrationBean<Slf4jTracingFilter> filterRegistrationBean = new FilterRegistrationBean<>(
            tracingFilter
        );
        filterRegistrationBean.setDispatcherTypes(
                DispatcherType.ASYNC,
                DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE,
                DispatcherType.REQUEST
        );
        filterRegistrationBean.setOrder(
                Ordered.HIGHEST_PRECEDENCE + 6
        );

        return filterRegistrationBean;
    }


    @Bean
    public Slf4jTracingFilter slf4jTracingFilter(HttpTracing tracing) {
        return Slf4jTracingFilter.create(tracing);

    }
}
