package com.xunyi.micro.shunt.propagation;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xunyi.micro.propagation.context.Context;
import com.xunyi.micro.propagation.context.CurrentContext;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

/**
 * 当前分流上下文
 */
public class CurrentShuntContext  {

    private CurrentContext currentContext;

    public CurrentShuntContext(CurrentContext currentContext) {
        this.currentContext = currentContext;
    }

    public ShuntContext get() {
        Context context = currentContext.get();
        if (context == null) {
            return null;
        }
        List<String> sequences = Collections.emptyList();
        String sequencesString = context.get("X-Sequences");
        if (sequencesString != null) {
            sequences = List.of(sequencesString.split(","));
        }

        return new ShuntContext(sequences);
    }

    /**
     * TODO 需要修改
     */
    public CurrentContext.Scope newScope(ShuntContext shuntContext) {
        Context context = new Context();
        List<String> sequences = shuntContext.sequences();
        if (sequences == null) {
            sequences = Collections.emptyList();
        }
        context.put("X-Sequences", Joiner.on(",").join(sequences));
        return currentContext.newScope(context);
    }

}
