package com.xunyi.micro.shunt.loadbalancer.group;

import com.google.common.base.Optional;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.*;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.propagation.ShuntContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ShuntingContextRule extends PredicateBasedRule {


    private Shunt shunt;

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
        super.initWithNiwsConfig(clientConfig);
    }

    @Override
    public Server choose(Object key) {
        ILoadBalancer lb = getLoadBalancer();
//        lb.getAllServers();

        Optional<Server> server = getPredicate().chooseRoundRobinAfterFiltering(lb.getAllServers(), key);
        if (server.isPresent()) {
            return server.get();
        } else {
            return null;
        }
    }

    @Override
    public AbstractServerPredicate getPredicate() {

        //获取当前分流上下文规则 并
        ShuntContext context = this.shunt.currentShuntContext().get();
        if (context == null) {
            return AbstractServerPredicate.alwaysTrue();
        }

        List<String> sequence = context.sequences();

        //特征服务
        List<AbstractServerPredicate> predicates = sequence.stream().map(ServerGroupShunting::new).map(ServerGroupPredicate::new).collect(Collectors.toList());

        //正常服务
        predicates.add(new ServerGroupPredicate(new ServerGroupShunting("standard")));
        predicates.add(new EmptyServerGroupPredicate());

        Iterator<AbstractServerPredicate> it = predicates.iterator();
        CompositePredicate.Builder builder = CompositePredicate.withPredicate(it.next());
        while (it.hasNext()) {
            builder.addFallbackPredicate(it.next());
        }
        return builder.build();
    }

    @Autowired
    public void setShunt(Shunt shunt) {
        this.shunt = shunt;
    }
}


