package com.xunyi.micro.security;

import com.xunyi.micro.security.configuration.PryPolicyConfigService;
import com.xunyi.micro.security.configuration.PryPolicyDataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean({PryPolicyDataSource.class})
public class PryAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public PryService pryService() {
        return new PryService();
    }


    @Bean
    @ConditionalOnBean({PryPolicyDataSource.class})
    @ConditionalOnMissingBean
    public PryPolicyConfigService task(PryPolicyDataSource dataSource) {
        return new PryPolicyConfigService(dataSource);
    }
}
