package com.xunyi.micro.propagation.instrument.web.servlet;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Context;
import com.xunyi.micro.propagation.context.CurrentContext;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

public class ServletPropagationFilter implements Filter {

    private Context.Extractor<HttpServletRequest> extractor;
    private CurrentContext currentContext;

    public ServletPropagationFilter(Propagation propagation, CurrentContext currentContext) {
        this.extractor = propagation.extractor(new Propagation.Getter<HttpServletRequest>() {
            @Override
            public String get(HttpServletRequest carrier, String key) {
                return carrier.getHeader(key);
            }

        });
        this.currentContext = currentContext;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        Context context = this.extractor.extract(httpRequest);
        try (CurrentContext.Scope scope = currentContext.newScope(context)) {
            chain.doFilter(request, response);
        }
    }
}
