package com.xunyi.micro.propagation.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;

import java.io.IOException;

public class PropagationLoadBalancerFeignClient extends LoadBalancerFeignClient {

    public PropagationLoadBalancerFeignClient(Client delegate, CachingSpringLoadBalancerFactory lbClientFactory, SpringClientFactory clientFactory) {
        super(delegate, lbClientFactory, clientFactory);
    }


    @Override
    public Response execute(Request request, Request.Options options) throws IOException {
        try {
            return super.execute(request, options);
        } catch (Exception e) {
            //记录跟踪
            throw e;
        } finally {

        }
    }
}
