package com.xunyi.micro.propagation.instrument.web.client.feign;

import feign.Client;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.util.ClassUtils;

public class PropagationFeignObjectWrapper {
    private static final boolean ribbonPresent;

    static {
        ribbonPresent = ClassUtils.isPresent(
                "org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient",
                null)
                && ClassUtils.isPresent(
                "org.springframework.cloud.netflix.ribbon.SpringClientFactory",
                null);
    }

    private final BeanFactory beanFactory;

    public PropagationFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }


    Object wrap(Object bean){
        if (bean instanceof Client && !(bean instanceof PropagationFeignClient)) {

            if (ribbonPresent && bean instanceof LoadBalancerFeignClient) {

            }
//            if (ribbonPresent && bean instanceof InjectorLoadBalancerFeignClient) {
//
//            }

            return new LazyPropagationFeignClient(this.beanFactory, (Client) bean);
        }
        return bean;
    }
}
