package com.xunyi.micro.propagation.instrument.web.client.feign;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Context;
import com.xunyi.micro.propagation.context.CurrentContext;
import feign.Client;
import feign.Request;
import feign.Response;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Shunt分流客户端
 */
@Slf4j
public class PropagationFeignClient implements Client {

    //传播
    static final Propagation.Setter<Map<String, Collection<String>>> SETTER = new Propagation.Setter<Map<String, Collection<String>>>() {
        @Override
        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                List<String> values = Lists.newArrayList();
                values.add(value);
                carrier.put(key, values);
            };
        }
    };

    private final CurrentContext currentContext;
    private final Client delegate;

    private Context.Injector<Map<String, Collection<String>>> injector;

    public PropagationFeignClient(CurrentContext currentContext, Propagation propagation, Client delegate) {
        this.currentContext = currentContext;
        this.delegate = delegate;
        this.injector = propagation.injector(SETTER);
    }


    @Override
    public Response execute(Request request, Request.Options options) throws IOException {

        Map<String, Collection<String>> headers = Maps.newHashMap(request.headers());
        Context context = currentContext.get();
        //注入
        this.injector.inject(context, headers);
        return this.delegate.execute(modifiedRequest(request, headers), options);
    }


    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        Request.HttpMethod method = request.httpMethod();
        String url = request.url();
        Request.Body body = request.requestBody();
        return Request.create(method, url, headers, body);
    }
}
