package com.xunyi.micro.propagation.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import org.springframework.beans.factory.BeanFactory;

import java.io.IOException;

/**
 * 惰性实现
 */
public class LazyClient implements Client {

    private final BeanFactory beanFactory;

    private Client delegate;

    public LazyClient(BeanFactory beanFactory) {
        this(beanFactory, null);
    }
    public LazyClient(BeanFactory beanFactory, Client delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    @Override
    public Response execute(Request request, Request.Options options) throws IOException {
        return null;
    }
}
