package com.xunyi.micro.propagation.context;

public abstract class CurrentContext {

    public abstract Context get();

    public abstract Scope newScope(Context context);




    public Scope maybeScope(Context context) {
        Context currentScope = get();
        if (context == null) {
            if (currentScope == null) return Scope.NOOP;
            return newScope(null);
        }
        return context.equals(currentScope) ? Scope.NOOP : newScope(context);
    }

    public interface Scope extends AutoCloseable {

        Scope NOOP = new Scope() {
            @Override
            public void close() throws RuntimeException { }

            @Override
            public String toString() {
                return "NoopScope";
            }
        };

        @Override
        void close() throws RuntimeException;
    }
}
