package com.xunyi.micro.propagation.autoconfig;

import com.xunyi.micro.propagation.DefaultPropagation;
import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.CurrentContext;
import com.xunyi.micro.propagation.context.ThreadLocalCurrentContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
//@ConditionalOnProperty(value = "micro.")
//@EnableConfigurationProperties
public class PropagationAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public CurrentContext currentContext() {
        return ThreadLocalCurrentContext.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public Propagation propagation() {
        return new DefaultPropagation(List.of("X-Sequences"));
    }

}
