package com.xunyi.micro.message;

public interface IErrorOwner {

    String getErrorCode();

    default Return toReturn() {
        XYError error = new XYError(this.getErrorCode());
        return Returns.error(error);
    }

    default Return toReturn(Object... args) {
        XYError error = new XYError(this.getErrorCode(), args);
        return Returns.error(error);
    };


    default ErrorException toException() {
        XYError error = new XYError(this.getErrorCode());
        return new ErrorException(error);
    }

    default ErrorException toException(Object... args) {
        XYError error = new XYError(this.getErrorCode(), args);
        return new ErrorException(error);
    }
}
