package com.xunyi.micro.grpc;

import io.grpc.netty.NegotiationType;

public class GRPCChannelProperties {

    public static final GRPCChannelProperties DEFAULT = new GRPCChannelProperties();

    /**
     * negotiation type
     * Defaults to {@code PLAINTEXT}
     */
    private NegotiationType negotiationType = NegotiationType.PLAINTEXT;

    /**
     * Setting to enable keepalive.
     * Default to {@code false}
     */
    private boolean enableKeepAlive = false;

    /**
     * Sets whether keepalive will be performed when there are no outstanding RPC on a connection.
     * Defaults to {@code false}.
     */
    private boolean keepAliveWithoutCalls = false;

    /**
     * The default delay in seconds before we send a keepalive.
     * Defaults to {@code 180}
     */
    private long keepAliveTime = 180;

    /**
     * The default timeout in seconds for a keepalive ping request.
     * Defaults to {@code 20}
     */
    private long keepAliveTimeout = 20;

    /**
     * The maximum message size allowed to be received on the channel.
     */
    private int maxInboundMessageSize;

    public NegotiationType getNegotiationType() {
        return negotiationType;
    }

    public void setNegotiationType(NegotiationType negotiationType) {
        this.negotiationType = negotiationType;
    }

    public boolean isEnableKeepAlive() {
        return enableKeepAlive;
    }

    public void setEnableKeepAlive(boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public boolean isKeepAliveWithoutCalls() {
        return keepAliveWithoutCalls;
    }

    public void setKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public long getKeepAliveTime() {
        return keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public long getKeepAliveTimeout() {
        return keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getMaxInboundMessageSize() {
        return maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }
}
