/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.rocket;

import com.google.common.collect.Maps;
import com.xunyi.rocket.RocketProducer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;

public class RocketClientBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private Map<String, List<Class>> beanToProcessClassMap = Maps.newHashMap();

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        Class<?> clazz = beanClass;
        do {
            for (Field field : beanClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(RocketProducer.class)) continue;
                if (!this.beanToProcessClassMap.containsKey("beanName")) {
                    this.beanToProcessClassMap.put(beanName, new ArrayList());
                }
                this.beanToProcessClassMap.get(beanName).add(clazz);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return super.postProcessBeforeInstantiation(beanClass, beanName);
    }

    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        if (this.beanToProcessClassMap.containsKey(beanName)) {
            try {
                Object target = this.getTargetBean(bean);
                for (Class clazz : this.beanToProcessClassMap.get(beanName)) {
                    for (Field field : clazz.getDeclaredFields()) {
                        RocketProducer annotation = (RocketProducer)AnnotationUtils.getAnnotation((AnnotatedElement)field, RocketProducer.class);
                        if (!Objects.nonNull(annotation)) continue;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.postProcessProperties(pvs, bean, beanName);
    }

    private Object getTargetBean(Object bean) throws Exception {
        Object target = bean;
        while (AopUtils.isAopProxy((Object)target)) {
            target = ((Advised)target).getTargetSource().getTarget();
        }
        return target;
    }
}

