/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.web;

import com.fasterxml.jackson.annotation.JsonValue;
import com.xunyi.micro.web.Terminal;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum OperatingSystem {
    WINDOWS("Windows", "Windows", Terminal.PC),
    ANDROID("Android", "Android", Terminal.MOBILE),
    CHROME_OS("Chrome OS", "CrOS", Terminal.PC),
    IOS("iOS", "iPhone,like Mac OS x", Terminal.MOBILE),
    MAC_OS_X("Mac OS X", "Mac OS X,CFNetwork", Terminal.PC),
    MAC_OS("Mac OS", "Mac", Terminal.PC),
    LINUX("Linux", "Linux,CamelHttpStream", Terminal.PC),
    UNKNOWN_MOBILE("Unknown Mobile", "Mobile", Terminal.MOBILE),
    UNKNOWN_TABLET("Unknown tablet", "Tablet", Terminal.PC),
    UNKNOWN("Unknown", "", Terminal.TABLET);

    private final String name;
    private final Set<String> aliases;
    private final Terminal terminal;

    private OperatingSystem(String name, String alias, Terminal terminal) {
        this.name = name;
        String[] aliases = alias.split(",");
        this.aliases = Arrays.stream(aliases).map(String::toLowerCase).collect(Collectors.toSet());
        this.terminal = terminal;
    }

    public boolean check(String agent) {
        agent = agent.toLowerCase();
        for (String alias : this.aliases) {
            if (!agent.contains(alias)) continue;
            return true;
        }
        return false;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public static OperatingSystem parseUserAgent(String agent) {
        if (agent != null) {
            for (OperatingSystem operatingSystem : OperatingSystem.values()) {
                if (!operatingSystem.check(agent)) continue;
                return operatingSystem;
            }
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.name;
    }
}

