/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.token;

import com.xunyi.micro.token.TokenNamed;
import com.xunyi.micro.token.exception.TokenExpiredException;
import java.time.Instant;

public class EmailToken
implements TokenNamed {
    private static final String NAME = "EmailToken";
    private String email;
    private Instant expiresAt;
    private Instant issuedAt;

    @Override
    public String name() {
        return NAME;
    }

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }
}

