/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt.web.servlet;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Extractor;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.propagation.CurrentShuntContext;
import com.xunyi.micro.shunt.propagation.ShuntContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ShuntFilter
implements Filter {
    private CurrentShuntContext currentShuntContext;
    private Extractor<HttpServletRequest> extractor;
    public static final Propagation.Getter<HttpServletRequest, String> GETTER = new Propagation.Getter<HttpServletRequest, String>(){

        @Override
        public String get(HttpServletRequest carrier, String key) {
            return carrier.getHeader(key);
        }
    };

    public ShuntFilter(Shunt shunt) {
        this.currentShuntContext = shunt.currentShuntContext();
        this.extractor = shunt.propagation().extractor(GETTER);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ShuntContext shuntContext = (ShuntContext)this.extractor.extract(httpRequest);
        try (CurrentShuntContext.Scope scope = this.currentShuntContext.newScope(shuntContext);){
            chain.doFilter(request, response);
        }
    }
}

