/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt.web.flux;

import com.xunyi.micro.propagation.Propagation;
import com.xunyi.micro.propagation.context.Extractor;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.propagation.CurrentShuntContext;
import com.xunyi.micro.shunt.propagation.ShuntContext;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.context.Context;

public class ShuntWebFilter
implements WebFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ShuntWebFilter.class);
    private CurrentShuntContext currentShuntContext;
    private Extractor<HttpHeaders> extractor;
    public static final Propagation.Getter<HttpHeaders, String> GETTER = new Propagation.Getter<HttpHeaders, String>(){

        @Override
        public String get(HttpHeaders carrier, String key) {
            return carrier.getFirst(key);
        }
    };

    public ShuntWebFilter(Shunt shunt) {
        this.currentShuntContext = shunt.currentShuntContext();
        this.extractor = shunt.propagation().extractor(GETTER);
    }

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, @NonNull WebFilterChain chain) {
        return new MonoWebFilterShunt((Mono<? extends Void>)chain.filter(exchange), exchange);
    }

    public int getOrder() {
        return -2147483644;
    }

    private class MonoWebFilterShunt
    extends MonoOperator<Void, Void> {
        final ServerWebExchange exchange;

        protected MonoWebFilterShunt(Mono<? extends Void> source, ServerWebExchange exchange) {
            super(source);
            this.exchange = exchange;
        }

        public void subscribe(@NonNull CoreSubscriber<? super Void> subscriber) {
            Context context = subscriber.currentContext();
            this.source.subscribe((CoreSubscriber)new WebFilterShuntSubscriber(subscriber, context, this.findOrCreateScope(context)));
        }

        private CurrentShuntContext.Scope findOrCreateScope(Context c) {
            CurrentShuntContext.Scope scope;
            Class<CurrentShuntContext.Scope> key = CurrentShuntContext.Scope.class;
            if (c.hasKey(key)) {
                scope = (CurrentShuntContext.Scope)c.get(key);
            } else {
                ServerHttpRequest request = this.exchange.getRequest();
                ShuntContext context = (ShuntContext)ShuntWebFilter.this.extractor.extract(request.getHeaders());
                scope = ShuntWebFilter.this.currentShuntContext.newScope(context);
            }
            return scope;
        }

        final class WebFilterShuntSubscriber
        implements CoreSubscriber<Void> {
            final CoreSubscriber<? super Void> actual;
            final Context context;
            final CurrentShuntContext.Scope scope;

            public WebFilterShuntSubscriber(CoreSubscriber<? super Void> actual, Context context, CurrentShuntContext.Scope scope) {
                this.actual = actual;
                this.context = context.put(CurrentShuntContext.Scope.class, (Object)scope);
                this.scope = scope;
            }

            public void onSubscribe(Subscription subscription) {
                this.actual.onSubscribe(subscription);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable t) {
                this.terminate();
                this.actual.onError(t);
            }

            public void onComplete() {
                this.terminate();
                this.actual.onComplete();
            }

            public Context currentContext() {
                return this.context;
            }

            private void terminate() {
                this.scope.close();
            }
        }
    }
}

