/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.micro.shunt.loadbalancer.group;

import com.google.common.base.Optional;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.CompositePredicate;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.PredicateBasedRule;
import com.netflix.loadbalancer.Server;
import com.xunyi.micro.shunt.Shunt;
import com.xunyi.micro.shunt.loadbalancer.group.EmptyServerGroupPredicate;
import com.xunyi.micro.shunt.loadbalancer.group.ServerGroupPredicate;
import com.xunyi.micro.shunt.loadbalancer.group.ServerGroupShunting;
import com.xunyi.micro.shunt.propagation.ShuntContext;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class ShuntingContextRule
extends PredicateBasedRule {
    private Shunt shunt;

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)((Object)this));
        super.initWithNiwsConfig(clientConfig);
    }

    public Server choose(Object key) {
        ILoadBalancer lb = this.getLoadBalancer();
        Optional server = this.getPredicate().chooseRoundRobinAfterFiltering(lb.getAllServers(), key);
        if (server.isPresent()) {
            return (Server)server.get();
        }
        return null;
    }

    public AbstractServerPredicate getPredicate() {
        ShuntContext context = this.shunt.currentShuntContext().get();
        if (context == null) {
            return AbstractServerPredicate.alwaysTrue();
        }
        List<String> sequence = context.sequences();
        List predicates = sequence.stream().map(ServerGroupShunting::new).map(ServerGroupPredicate::new).collect(Collectors.toList());
        predicates.add(new ServerGroupPredicate(new ServerGroupShunting("standard")));
        predicates.add(new EmptyServerGroupPredicate());
        Iterator it = predicates.iterator();
        CompositePredicate.Builder builder = CompositePredicate.withPredicate((AbstractServerPredicate)((AbstractServerPredicate)it.next()));
        while (it.hasNext()) {
            builder.addFallbackPredicate((AbstractServerPredicate)it.next());
        }
        return builder.build();
    }

    @Autowired
    public void setShunt(Shunt shunt) {
        this.shunt = shunt;
    }
}

